/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.config;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.api.jdbc.PGNotificationListener;
import io.dataintell.visionapi.scanner.JobProcessor;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationListener
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(NotificationListener.class);
    public static final String JOB_SUCCESS_CHANNEL = "job_success_channel";
    public static final String NEW_JOB_CHANNEL = "new_job_channel";
    private final PGConnection connection;
    private final JobProcessor jobProcessor;

    public NotificationListener(String url, String user, String password, JobProcessor jobProcessor) throws SQLException {
        this.connection = DriverManager.getConnection(url, user, password).unwrap(PGConnection.class);
        this.jobProcessor = jobProcessor;
    }

    @Override
    public void run() {
        this.connection.addNotificationListener((PGNotificationListener)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Statement statement = this.connection.createStatement();
            try {
                statement.execute("LISTEN job_success_channel");
                statement.execute("LISTEN new_job_channel");
                while (true) {
                    // Infinite loop
                }
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            logger.error(String.format("Unable to subscribe to %s because %s", JOB_SUCCESS_CHANNEL, e.getMessage()));
            return;
        }
    }
}

