/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.config;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Elasticsearch {
    @Value(value="${elasticsearch.port}")
    private Integer elasticsearchPort;
    @Value(value="${elasticsearch.host}")
    private String elasticsearchHost;
    @Value(value="${elasticsearch.protocol}")
    private String elasticsearchProtocol;
    @Value(value="${elasticsearch.user}")
    private String elasticsearchUser;
    @Value(value="${elasticsearch.password}")
    private String elasticsearchPassword;

    @Bean
    public RestHighLevelClient elasticsearchClient() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.elasticsearchHost, this.elasticsearchPort.intValue(), this.elasticsearchProtocol)}).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(10000).setSocketTimeout(120000));
        if (StringUtils.isNotBlank((CharSequence)this.elasticsearchUser) && StringUtils.isNotBlank((CharSequence)this.elasticsearchPassword)) {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.elasticsearchUser, this.elasticsearchPassword));
            builder.setHttpClientConfigCallback(arg_0 -> Elasticsearch.lambda$elasticsearchClient$2((CredentialsProvider)credentialsProvider, arg_0));
        }
        return new RestHighLevelClient(builder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$elasticsearchClient$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setKeepAliveStrategy((response, context) -> Duration.ofMinutes(5L).toMillis());
    }
}

