/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.archiwareScanner;

import io.dataintell.visionapi.archiwareScanner.ArchiwareClient;
import io.dataintell.visionapi.archiwareScanner.FileBuilderFromArchiware;
import io.dataintell.visionapi.domain.ArchiwareFile;
import io.dataintell.visionapi.domain.ArchiwareP5Index;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.file.IngestFileProcessor;
import io.dataintell.visionapi.service.VolumeService;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanIndexHandler {
    private static final Logger log = LoggerFactory.getLogger(ScanIndexHandler.class);
    private final HashMap<String, File> folderList;
    private final ArchiwareP5Index archiwareP5IndexConfiguration;
    private final long volumeId;
    private final String volumeName;
    private final IngestFileProcessor ingestFileProcessor;
    private final VolumeService volumeService;
    private final FileBuilderFromArchiware fileBuilderFromArchiware;
    private final ArchiwareClient archiwareClient;
    private Long indexSize = 0L;
    private static final Logger logger = LoggerFactory.getLogger(ScanIndexHandler.class);

    public ScanIndexHandler(ArchiwareP5Index archiwareP5IndexConfiguration, long volumeId, String volumeName, IngestFileProcessor ingestFileProcessor, VolumeService volumeService) {
        this.archiwareP5IndexConfiguration = archiwareP5IndexConfiguration;
        this.volumeId = volumeId;
        this.volumeName = volumeName;
        this.ingestFileProcessor = ingestFileProcessor;
        this.volumeService = volumeService;
        this.folderList = new HashMap();
        this.fileBuilderFromArchiware = new FileBuilderFromArchiware();
        this.archiwareClient = new ArchiwareClient(archiwareP5IndexConfiguration.getArchiwareP5Credential().getUrl(), archiwareP5IndexConfiguration.getArchiwareP5Credential().getUsername(), archiwareP5IndexConfiguration.getArchiwareP5Credential().getPassword());
    }

    public void scanArchiwareIndex() {
        try {
            long start = System.currentTimeMillis();
            logger.info("About to start the scan of the Archiware P5 index [{}], with path [{}] and volumeId [{}]", new Object[]{this.archiwareP5IndexConfiguration.getIndexId(), this.archiwareP5IndexConfiguration.getPath(), this.archiwareP5IndexConfiguration.getVolumeSettingId()});
            this.scanArchiwarePath(this.archiwareP5IndexConfiguration.getPath());
            long time = System.currentTimeMillis() - start;
            Volume volume = Volume.builder().id(Long.valueOf(this.volumeId)).name(this.volumeName).indexingDate(new Date()).free(Long.valueOf(0L)).used(this.indexSize).total(this.indexSize).crawlDuration(Long.valueOf(time)).type("Archives").productName("Archiware-P5").build();
            this.volumeService.saveVolume(volume);
            log.info("Scanning archiware id[{}], index[{}] took {} ms", new Object[]{this.archiwareP5IndexConfiguration.getId(), this.archiwareP5IndexConfiguration.getIndexId(), time});
        }
        catch (RuntimeException e) {
            log.error("There was an error scanning Archiware P5 index [{}], with path [{}] and volumeId [{}]", new Object[]{this.archiwareP5IndexConfiguration.getIndexId(), this.archiwareP5IndexConfiguration.getPath(), this.archiwareP5IndexConfiguration.getVolumeSettingId(), e});
        }
    }

    private void scanArchiwarePath(String path) {
        List archiwareFiles = this.archiwareClient.getInventory(this.archiwareP5IndexConfiguration.getIndexId(), path);
        for (ArchiwareFile file : archiwareFiles) {
            if (file.getType().equals("File")) {
                this.ingestFileProcessor.processFile(this.fileBuilderFromArchiware.createDataIntellFileFromArchiwareVolume(file, this.volumeName, Long.valueOf(this.volumeId), this.archiwareP5IndexConfiguration.getPath()));
                this.indexSize = this.indexSize + file.getSize();
                this.updateParentFolder(file);
                continue;
            }
            if (file.getValidPath().equals(path)) continue;
            this.preVisitDirectory(file);
            this.scanArchiwarePath(file.getValidPath());
            this.postVisitDirectory(file);
        }
    }

    private void updateParentFolder(ArchiwareFile file) {
        String parentPath = Path.of(file.getValidPath(), new String[0]).getParent().toString();
        if (this.folderList.get(parentPath) != null) {
            File dataIntellFolder = (File)this.folderList.get(parentPath);
            dataIntellFolder.setSize(Long.valueOf(dataIntellFolder.getSize() + file.getSize()));
            dataIntellFolder.setNumberOfFiles(Long.valueOf(dataIntellFolder.getNumberOfFiles() + 1L));
            if (dataIntellFolder.getLastModified().before(new Date(file.getMtime() * 1000L))) {
                dataIntellFolder.setLastModified(new Date(file.getMtime() * 1000L));
            }
            this.folderList.put(parentPath, dataIntellFolder);
        }
    }

    private void postVisitDirectory(ArchiwareFile file) {
        File dataIntellFolder = (File)this.folderList.get(file.getValidPath());
        String parentPath = Path.of(file.getValidPath(), new String[0]).getParent().toString();
        if (!parentPath.equals(this.archiwareP5IndexConfiguration.getPath())) {
            File dataIntellParentFolder = (File)this.folderList.get(parentPath);
            if (dataIntellParentFolder == null) {
                logger.debug(String.format("File: " + file + "ParentPath: " + parentPath, new Object[0]));
            }
            dataIntellParentFolder.setSize(Long.valueOf(dataIntellParentFolder.getSize() + dataIntellFolder.getSize()));
            dataIntellParentFolder.setNumberOfFolders(Long.valueOf(dataIntellParentFolder.getNumberOfFolders() + dataIntellFolder.getNumberOfFolders() + 1L));
            dataIntellParentFolder.setNumberOfFiles(Long.valueOf(dataIntellParentFolder.getNumberOfFiles() + dataIntellFolder.getNumberOfFiles()));
            if (dataIntellParentFolder.getLastModified().before(dataIntellFolder.getLastModified())) {
                dataIntellParentFolder.setLastModified(dataIntellFolder.getLastModified());
            }
            this.folderList.put(parentPath, dataIntellParentFolder);
        }
        this.ingestFileProcessor.processFile(dataIntellFolder);
    }

    private void preVisitDirectory(ArchiwareFile file) {
        this.folderList.put(file.getValidPath(), this.fileBuilderFromArchiware.createDataIntellFolderFromArchiwareVolume(file, this.volumeName, Long.valueOf(this.volumeId), this.archiwareP5IndexConfiguration.getPath()));
    }
}

