/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.archiwareScanner;

import io.dataintell.visionapi.domain.ArchiwareFile;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.utils.FormatUtils;
import io.dataintell.visionapi.utils.HashUtils;
import io.dataintell.visionapi.utils.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component
public class FileBuilderFromArchiware {
    public File createDataIntellFileFromArchiwareVolume(ArchiwareFile archiwareFile, String volumeName, Long volumeId, String volumePath) {
        File fileDataintell = new File();
        Path path = Paths.get(archiwareFile.getValidPath(), new String[0]);
        fileDataintell.setName(archiwareFile.getName());
        fileDataintell.setPath(this.formatPath(path.getParent().toString(), volumePath));
        fileDataintell.setLastModified(new Date(archiwareFile.getMtime() * 1000L));
        HashMap<String, Date> metadata = new HashMap<String, Date>();
        metadata.put("backupDate", new Date(archiwareFile.getBtime() * 1000L));
        fileDataintell.setMetadata(metadata);
        int index = archiwareFile.getName().lastIndexOf(46);
        if (index > 0) {
            String extension = archiwareFile.getName().substring(index + 1);
            fileDataintell.setExtension(extension);
        }
        fileDataintell.setGroup("");
        fileDataintell.setCreationDate(new Date(archiwareFile.getCtime() * 1000L));
        fileDataintell.setVolumeId(volumeId);
        fileDataintell.setVolumeName(volumeName);
        fileDataintell.setOwner("");
        fileDataintell.setSize(archiwareFile.getSize());
        fileDataintell.setIsDirectory(Boolean.valueOf(!archiwareFile.getType().equals("File")));
        fileDataintell.setIsDeleted(Boolean.valueOf(false));
        fileDataintell.setIsDupe(Boolean.valueOf(false));
        fileDataintell.setIndexingDate(new Date());
        fileDataintell.setNumericNameList(StringUtils.removeAllNonNumericAndReturnListOfNumbers((String)archiwareFile.getName()));
        fileDataintell.setFileId(HashUtils.getDocumentId((String)("f-" + fileDataintell.getName()), (String)fileDataintell.getPath(), null, (Boolean)fileDataintell.getIsDirectory()));
        fileDataintell.setIdentificationHash(HashUtils.createMD5Hash((String)(fileDataintell.getName() + fileDataintell.getLastModified().toString() + fileDataintell.getSize())));
        return fileDataintell;
    }

    public File createDataIntellFolderFromArchiwareVolume(ArchiwareFile file, String volumeName, Long volumeId, String volumePath) {
        File dataintellFolder = new File();
        dataintellFolder.setPath(this.formatPath(file.getValidPath(), volumePath));
        dataintellFolder.setIsDeleted(Boolean.valueOf(false));
        dataintellFolder.setCreationDate(new Date(file.getCtime() * 1000L));
        dataintellFolder.setVolumeId(volumeId);
        dataintellFolder.setName(file.getName());
        dataintellFolder.setSize(Long.valueOf(0L));
        dataintellFolder.setNumberOfFolders(Long.valueOf(0L));
        dataintellFolder.setNumberOfFiles(Long.valueOf(0L));
        dataintellFolder.setVolumeName(volumeName);
        dataintellFolder.setOwner("");
        dataintellFolder.setIsDirectory(Boolean.valueOf(true));
        dataintellFolder.setIndexingDate(new Date());
        dataintellFolder.setLastModified(new Date(file.getMtime() * 1000L));
        HashMap<String, Date> metadata = new HashMap<String, Date>();
        metadata.put("backupDate", file.getBtime() == 0L ? null : new Date(file.getBtime() * 1000L));
        dataintellFolder.setMetadata(metadata);
        dataintellFolder.setNumericNameList(StringUtils.removeAllNonNumericAndReturnListOfNumbers((String)file.getName()));
        dataintellFolder.setFileId(HashUtils.getDocumentId((String)dataintellFolder.getName(), (String)dataintellFolder.getPath(), (Long)dataintellFolder.getVolumeId(), (Boolean)dataintellFolder.getIsDirectory()));
        dataintellFolder.setIdentificationHash(HashUtils.getMD5Hash((File)dataintellFolder));
        return dataintellFolder;
    }

    private String formatPath(String path, String volumePath) {
        String formatPath = FormatUtils.formatPath((String)path, (String)volumePath);
        return formatPath.startsWith("/") ? formatPath : "/" + formatPath;
    }
}

