/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.archiwareScanner;

import io.dataintell.visionapi.archiwareScanner.ArchiwareJobName;
import io.dataintell.visionapi.archiwareScanner.ArchiwareJobNames;
import io.dataintell.visionapi.archiwareScanner.Job;
import io.dataintell.visionapi.domain.ArchiwareFile;
import io.dataintell.visionapi.domain.ArchiwareFiles;
import io.dataintell.visionapi.domain.ArchiwareIndex;
import io.dataintell.visionapi.domain.ArchiwareIndexes;
import io.dataintell.visionapi.domain.ArchiwareJob;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ArchiwareClient {
    private static final Logger log = LoggerFactory.getLogger(ArchiwareClient.class);
    private final RestTemplate restTemplate;
    private final String url;

    public ArchiwareClient(String url, String username, String password) {
        this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).basicAuthentication(username, password).build();
        this.url = url;
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<ArchiwareFile> getInventory(String indexId, String path) {
        ArrayList<ArchiwareFile> emptyInventory = new ArrayList<ArchiwareFile>();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)this.url).path("/rest/v1/archive/indexes/" + indexId + "/inventory" + path).build();
        try {
            ArchiwareFiles archiwareFiles = (ArchiwareFiles)this.restTemplate.getForObject(uriComponents.toUri(), ArchiwareFiles.class);
            return archiwareFiles != null ? archiwareFiles.getInventory() : emptyInventory;
        }
        catch (HttpClientErrorException.NotFound e) {
            log.error("Error NOT FOUND while fetching inventory from Archiware with path [{}] and indexId [{}]", (Object)path, (Object)indexId);
            return emptyInventory;
        }
    }

    public List<ArchiwareJob> getJobsByDate(int numberOfDays) {
        ArrayList<Long> jobIds = new ArrayList<Long>();
        HttpHeaders headers = new HttpHeaders();
        headers.set("filter", "all");
        headers.set("lastdays", String.valueOf(numberOfDays));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)this.url).path("/rest/v1/general/jobs").build();
        ResponseEntity archiwareJobNamesResponseEntity = this.restTemplate.exchange(uriComponents.toUri(), HttpMethod.GET, entity, ArchiwareJobNames.class);
        if (null != archiwareJobNamesResponseEntity.getBody()) {
            List archiwareJobNames = ((ArchiwareJobNames)archiwareJobNamesResponseEntity.getBody()).getJobs();
            for (ArchiwareJobName archiwareJobName : archiwareJobNames) {
                jobIds.add(archiwareJobName.getId());
            }
        }
        return this.getJobsDetails(jobIds);
    }

    public List<String> getArchiwareIndexes() {
        ArrayList<String> indexes = new ArrayList<String>();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)this.url).path("/rest/v1/archive/indexes").build();
        ArchiwareIndexes archiwareIndexes = (ArchiwareIndexes)this.restTemplate.getForObject(uriComponents.toUri(), ArchiwareIndexes.class);
        if (null != archiwareIndexes) {
            for (ArchiwareIndex index : archiwareIndexes.getIndexes()) {
                indexes.add(index.getId());
            }
        }
        return indexes;
    }

    private List<ArchiwareJob> getJobsDetails(List<Long> jobIds) {
        ArrayList<ArchiwareJob> ArchiwareJobs = new ArrayList<ArchiwareJob>();
        HttpHeaders headers = new HttpHeaders();
        headers.set("format", "json");
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        for (Long jobId : jobIds) {
            UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)this.url).path("/rest/v1/general/jobs/" + jobId + "/protocol").build();
            ResponseEntity job = this.restTemplate.exchange(uriComponents.toUri(), HttpMethod.GET, entity, Job.class);
            if (null != job.getBody()) {
                ((Job)job.getBody()).setId(String.valueOf(jobId));
            }
            ArchiwareJobs.add(new ArchiwareJob((Job)job.getBody()));
        }
        return ArchiwareJobs;
    }
}

