/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi;

import io.dataintell.visionapi.config.NotificationListener;
import io.dataintell.visionapi.scanner.JobProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableJpaAuditing
@EnableAsync
@EnableScheduling
public class VisionApiApplication
implements CommandLineRunner {
    @Value(value="${dataintell.scanner.postgresql.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String user;
    @Value(value="${spring.datasource.password}")
    private String password;

    public static void main(String[] args) {
        SpringApplication.run(VisionApiApplication.class, (String[])args);
    }

    @Bean
    public JobProcessor jobProcessor() {
        return new JobProcessor();
    }

    public void run(String ... args) throws Exception {
        NotificationListener listener = new NotificationListener(this.url, this.user, this.password, this.jobProcessor());
        listener.start();
    }
}

