/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.visitor;

import io.dataintell.scanner.domain.File;
import io.dataintell.scanner.file.IngestFileProcessor;
import io.dataintell.scanner.utils.HashUtils;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanQueue {
    private static final Logger logger = LoggerFactory.getLogger(ScanQueue.class);
    private final ConcurrentHashMap<String, File> directoryQueue = new ConcurrentHashMap();
    private final IngestFileProcessor ingestFileProcessor;

    public ScanQueue(IngestFileProcessor ingestFileProcessor) {
        this.ingestFileProcessor = ingestFileProcessor;
    }

    public void addFileToQueue(File file) {
        this.ingestFileProcessor.processFile(file);
    }

    public void initiateDirectory(File directory) {
        this.directoryQueue.putIfAbsent(directory.getPath(), directory);
    }

    public void updateDirectory(String path, Long size, Date lastAccessDate, Date lastModifiedDate, Long numberOfFiles, Long numberOfFolders) {
        File directory = (File)this.directoryQueue.get(path);
        if (directory == null) {
            logger.error(String.format("Unable to update directory with path [%s] because it's no logger in the queue", path));
            return;
        }
        directory.setSize(Long.valueOf(directory.getSize() + size));
        directory.setNumberOfFiles(Long.valueOf(directory.getNumberOfFiles() + numberOfFiles));
        directory.setNumberOfFolders(Long.valueOf(directory.getNumberOfFolders() + numberOfFolders));
        if (directory.getLastAccess().before(lastAccessDate)) {
            directory.setLastAccess(lastAccessDate);
        }
        if (directory.getLastModified().before(lastModifiedDate)) {
            directory.setLastModified(lastModifiedDate);
        }
    }

    public void updateDirectoryWithChild(String childPath, String path) {
        if (childPath.equals("/")) {
            return;
        }
        File directory = (File)this.directoryQueue.get(childPath);
        if (directory == null) {
            logger.error(String.format("Unable to update directory parent [%s] with child path [%s] because it's no logger in the queue", path, childPath));
            return;
        }
        this.updateDirectory(path, directory.getSize(), directory.getLastAccess(), directory.getLastModified(), directory.getNumberOfFiles(), Long.valueOf(directory.getNumberOfFolders() + 1L));
    }

    public void addDirectoryToQueue(String path) {
        File directory = (File)this.directoryQueue.get(path);
        if (directory == null) {
            logger.error(String.format("Unable to save directory with path [%s] because it's no logger in the queue", path));
            return;
        }
        directory.setIdentificationHash(HashUtils.createMD5Hash((String)("d-" + directory.getCreationDate().toString() + directory.getSize() + directory.getNumberOfFiles() + "-" + directory.getNumberOfFolders())));
        this.addFileToQueue(directory);
        this.directoryQueue.remove(path);
    }

    public void emptyDirectoryQueue() {
        this.directoryQueue.values().forEach(arg_0 -> this.addFileToQueue(arg_0));
    }
}

