/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.visitor;

import io.dataintell.scanner.domain.File;
import io.dataintell.scanner.utils.FileBuilder;
import io.dataintell.scanner.visitor.ScanQueue;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullScanVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(FullScanVisitor.class);
    private final FileBuilder fileBuilder;
    private final ScanQueue scanQueue;
    private final String volumeName;
    private final Long volumeId;
    private final String mountPath;
    private final Date lastScan;
    private String fullScanForPath;
    private final String pathToScan;

    public FullScanVisitor(FileBuilder fileBuilder, ScanQueue scanQueue, String volumeName, Long volumeId, String mountPath, String pathToScan, Date lastScan) {
        this.fileBuilder = fileBuilder;
        this.scanQueue = scanQueue;
        this.volumeName = volumeName;
        this.volumeId = volumeId;
        this.mountPath = mountPath;
        this.lastScan = lastScan;
        this.pathToScan = pathToScan;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attr) throws IOException {
        if (Files.isSymbolicLink(path) || Files.isDirectory(path, new LinkOption[0])) {
            return FileVisitResult.CONTINUE;
        }
        this.scanQueue.updateDirectory(this.fileBuilder.formatPath(path.getParent().toString(), this.mountPath), Long.valueOf(attr.size()), new Date(attr.lastAccessTime().toMillis()), new Date(attr.lastModifiedTime().toMillis()), Long.valueOf(1L), Long.valueOf(0L));
        if (!this.fileBuilder.doesScanIsNeeded(attr, this.lastScan).booleanValue() && this.fullScanForPath == null) {
            return FileVisitResult.CONTINUE;
        }
        File file = this.fileBuilder.createFile(path, attr, this.mountPath, this.volumeName, this.volumeId, this.lastScan);
        this.scanQueue.addFileToQueue(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        if (dir.toString().equals(this.fullScanForPath)) {
            this.fullScanForPath = null;
        }
        String childPath = this.fileBuilder.formatPath(dir.toString(), this.mountPath);
        String parentPath = dir.getParent() == null ? "" : dir.getParent().toString();
        String path = this.fileBuilder.formatPath(parentPath, this.mountPath);
        this.scanQueue.updateDirectoryWithChild(childPath, path);
        if (!dir.toString().equals(this.pathToScan)) {
            this.scanQueue.addDirectoryToQueue(childPath);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attr) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return FileVisitResult.CONTINUE;
        }
        File directory = this.fileBuilder.createDirectory(path, attr, this.mountPath, this.volumeName, this.volumeId);
        if (this.fullScanForPath == null && this.fileBuilder.doesScanFolderIsNeeded(attr, this.lastScan).booleanValue()) {
            this.fullScanForPath = path.toString();
        }
        this.scanQueue.initiateDirectory(directory);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
        if (path.toString().equals(this.mountPath)) {
            throw exc;
        }
        logger.error(String.format("Unable to scan the file [%s]", exc.getMessage()));
        return FileVisitResult.CONTINUE;
    }

    public String getFullScanForPath() {
        return this.fullScanForPath;
    }

    public void setFullScanForPath(String fullScanForPath) {
        this.fullScanForPath = fullScanForPath;
    }
}

