/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.utils;

import io.dataintell.scanner.utils.ESFileQueryUtils;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.springframework.stereotype.Component;

@Component
public class ESSearchFileUtils {
    public static BoolQueryBuilder getInitialBoolQueryBuilderForSearch(Boolean onlyDuplicate, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Long minimumSize, Long maximumSize, Boolean isDirectory, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, List<String> searchWords, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders) {
        BoolQueryBuilder boolQuery = ESFileQueryUtils.getBasicBoolQueryBuilder((Boolean)isDirectory, (Boolean)showOnlyDeletedFiles);
        if (volumesAndPaths != null && volumesAndPaths.size() > 0) {
            BoolQueryBuilder volumesAndPathsBoolQuery = new BoolQueryBuilder();
            for (String volumesAndPath : volumesAndPaths) {
                String[] volumeAndPathTable = volumesAndPath.split(",");
                BoolQueryBuilder volumeAndPathBoolQuery = new BoolQueryBuilder();
                volumeAndPathBoolQuery.must((QueryBuilder)new TermQueryBuilder("volumeId", volumeAndPathTable[0]));
                volumeAndPathBoolQuery.must((QueryBuilder)new PrefixQueryBuilder("path", volumeAndPathTable[1]));
                volumesAndPathsBoolQuery.should((QueryBuilder)volumeAndPathBoolQuery);
            }
            volumesAndPathsBoolQuery.minimumShouldMatch(1);
            boolQuery.must((QueryBuilder)volumesAndPathsBoolQuery);
        }
        for (String searchWord : searchWords) {
            boolQuery.must((QueryBuilder)new QueryStringQueryBuilder(searchWord).type(MultiMatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        if (onlyDuplicate != null) {
            boolQuery.must((QueryBuilder)new TermQueryBuilder("isDupe", (Object)onlyDuplicate));
        }
        if (volumeIds != null) {
            BoolQueryBuilder volumeBoolQuery = new BoolQueryBuilder();
            volumeIds.forEach(volumeId -> volumeBoolQuery.should((QueryBuilder)new TermQueryBuilder("volumeId", volumeId)));
            volumeBoolQuery.minimumShouldMatch(1);
            boolQuery.must((QueryBuilder)volumeBoolQuery);
        }
        if (startingPath != null) {
            boolQuery.must((QueryBuilder)new PrefixQueryBuilder("path", startingPath));
        }
        if (owner != null) {
            boolQuery.must((QueryBuilder)new TermQueryBuilder("owner", owner));
        }
        if (group != null) {
            boolQuery.must((QueryBuilder)new TermQueryBuilder("group", group));
        }
        if (lastAccessAfter != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("lastAccess").gte((Object)lastAccessAfter.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (lastAccessBefore != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("lastAccess").lte((Object)lastAccessBefore.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (creationAfter != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("creationDate").gte((Object)creationAfter.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (creationBefore != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("creationDate").lte((Object)creationBefore.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (lastModifiedAfter != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("lastModified").gte((Object)lastModifiedAfter.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (lastModifiedBefore != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("lastModified").lte((Object)lastModifiedBefore.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (minimumSize != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("size").gte((Object)minimumSize));
        }
        if (maximumSize != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("size").lte((Object)maximumSize));
        }
        if (minimumNumberOfFiles != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("numberOfFiles").gte((Object)minimumNumberOfFiles));
        }
        if (maximumNumberOfFiles != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("numberOfFiles").lte((Object)maximumNumberOfFiles));
        }
        if (minimumNumberOfFolders != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("numberOfFolders").gte((Object)minimumNumberOfFolders));
        }
        if (maximumNumberOfFolders != null) {
            boolQuery.must((QueryBuilder)new RangeQueryBuilder("numberOfFolders").lte((Object)maximumNumberOfFolders));
        }
        if (extensions != null) {
            BoolQueryBuilder extensionBoolQuery = new BoolQueryBuilder();
            extensions.forEach(extension -> extensionBoolQuery.should((QueryBuilder)new TermQueryBuilder("extension", extension)));
            extensionBoolQuery.minimumShouldMatch(1);
            boolQuery.must((QueryBuilder)extensionBoolQuery);
        }
        return boolQuery;
    }
}

