/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

/*
 * Exception performing whole class analysis ignored.
 */
public class ESFileQueryUtils {
    public static SearchRequest getSearchRequest(QueryBuilder searchQuery, String fieldSort, SortOrder sortDirection, Integer from, Integer size, Boolean trackTotalHits, String indexName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = ESFileQueryUtils.getSearchSourceBuilder((QueryBuilder)searchQuery, (String)fieldSort, (SortOrder)sortDirection, (Integer)from, (Integer)size, (Boolean)trackTotalHits);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    public static SearchRequest getSearchRequestWithAggregation(QueryBuilder searchQuery, String fieldSort, SortOrder sortDirection, Integer from, Integer size, Boolean trackTotalHits, List<AggregationBuilder> aggregationBuilders, String indexName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = ESFileQueryUtils.getSearchSourceBuilder((QueryBuilder)searchQuery, (String)fieldSort, (SortOrder)sortDirection, (Integer)from, (Integer)size, (Boolean)trackTotalHits);
        for (AggregationBuilder aggregationBuilder : aggregationBuilders) {
            searchSourceBuilder.aggregation(aggregationBuilder);
        }
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    public static SearchRequest getScrollSearchRequest(QueryBuilder searchQuery, String fieldSort, SortOrder sortDirection, Integer timeToLive, Integer size, String indexName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(searchQuery).sort(ESFileQueryUtils.getSortBuilder((String)fieldSort, (SortOrder)sortDirection)).size(size.intValue());
        searchRequest.source(searchSourceBuilder).scroll(new TimeValue((long)timeToLive.intValue()));
        return searchRequest;
    }

    public static BoolQueryBuilder getBasicBoolQueryBuilder(Boolean isDirectory, Boolean showOnlyDeletedFiles) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must((QueryBuilder)new TermQueryBuilder("isDirectory", (Object)isDirectory));
        if (showOnlyDeletedFiles == null) {
            boolQueryBuilder.must((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        } else if (showOnlyDeletedFiles.booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)new TermQueryBuilder("isDeleted", true));
        }
        return boolQueryBuilder;
    }

    public static String getIndexName(LocalDate indexingDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return "file-" + indexingDate.format(formatter);
    }

    public static SearchSourceBuilder getSearchSourceBuilder(QueryBuilder searchQuery, String fieldSort, SortOrder sortDirection, Integer from, Integer size, Boolean trackTotalHits) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(searchQuery).sort(ESFileQueryUtils.getSortBuilder((String)fieldSort, (SortOrder)sortDirection)).from(from.intValue()).size(size.intValue()).trackTotalHits(trackTotalHits.booleanValue());
        return searchSourceBuilder;
    }

    private static SortBuilder<FieldSortBuilder> getSortBuilder(String fieldSort, SortOrder sortDirection) {
        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)fieldSort);
        sortBuilder.order(sortDirection);
        return sortBuilder;
    }
}

