/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.service;

import io.dataintell.scanner.config.ThreadPoolConfig;
import io.dataintell.scanner.domain.File;
import io.dataintell.scanner.domain.FolderToScan;
import io.dataintell.scanner.domain.PaginatedResult;
import io.dataintell.scanner.domain.PathScan;
import io.dataintell.scanner.domain.Volume;
import io.dataintell.scanner.domain.VolumeScan;
import io.dataintell.scanner.domain.VolumeSetting;
import io.dataintell.scanner.file.BulkProcessorFactory;
import io.dataintell.scanner.file.IngestFileProcessor;
import io.dataintell.scanner.job.Payload;
import io.dataintell.scanner.mapper.FileMapper;
import io.dataintell.scanner.repository.ESRepository;
import io.dataintell.scanner.service.DeletedFileService;
import io.dataintell.scanner.utils.FileBuilder;
import io.dataintell.scanner.utils.VolumeBuilder;
import io.dataintell.scanner.visitor.FullScanVisitor;
import io.dataintell.scanner.visitor.InitialScanVisitor;
import io.dataintell.scanner.visitor.ScanQueue;
import io.netty.util.internal.ConcurrentSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScanService {
    private final Logger logger = LoggerFactory.getLogger(ScanService.class);
    private final ESRepository esRepository;
    private final VolumeBuilder volumeBuilder;
    private final FileBuilder fileBuilder;
    private final FileMapper fileMapper;
    private final DeletedFileService deletedFilesManager;
    private final ThreadPoolConfig threadPoolConfig;
    private final BulkProcessorFactory bulkProcessorFactory;
    @Value(value="${dataintell.scanner.multithread.folder.depth}")
    private Integer multithreadFolderDepth;

    public ScanService(ESRepository esRepository, VolumeBuilder volumeBuilder, FileBuilder fileBuilder, FileMapper fileMapper, DeletedFileService deletedFilesManager, ThreadPoolConfig threadPoolConfig, BulkProcessorFactory bulkProcessorFactory) {
        this.esRepository = esRepository;
        this.volumeBuilder = volumeBuilder;
        this.fileBuilder = fileBuilder;
        this.fileMapper = fileMapper;
        this.deletedFilesManager = deletedFilesManager;
        this.threadPoolConfig = threadPoolConfig;
        this.bulkProcessorFactory = bulkProcessorFactory;
    }

    public void scanVolumes(Payload payload) throws InterruptedException, IOException {
        Date scanDate = new Date();
        List volumeSettings = payload.getVolumeSettings();
        LocalDate indexingDate = payload.getIndexingDate();
        boolean isFirstScanOfTheDay = payload.isFirstScanOfTheDay();
        IngestFileProcessor ingestFileProcessor = new IngestFileProcessor(this.bulkProcessorFactory.makeBulkProcessor(), indexingDate, isFirstScanOfTheDay);
        List volumeScans = this.getVolumeScansForVolumes(volumeSettings, indexingDate, ingestFileProcessor);
        ConcurrentHashMap volumesPathsCount = new ConcurrentHashMap();
        volumeScans.forEach(v -> {
            ConcurrentSet pathSet = new ConcurrentSet();
            v.getPathList().forEach(p -> pathSet.add((Object)p.toString()));
            volumesPathsCount.put(v.getVolumeSetting().getId(), pathSet);
        });
        List paths = this.getPathScans(volumeScans);
        ArrayList callableList = new ArrayList();
        paths.forEach(pathScan -> callableList.add(() -> {
            this.scanPath(pathScan.getVolumeSetting(), pathScan.getFolderToScan(), pathScan.getScanQueue(), pathScan.getLastScanDate());
            Long volumeId = pathScan.getVolumeSetting().getId();
            ConcurrentSet pathSet = (ConcurrentSet)volumesPathsCount.get(volumeId);
            pathSet.remove((Object)pathScan.getFolderToScan().toString());
            if (pathSet.size() == 0) {
                this.finishVolumeScan(pathScan.getVolumeSetting(), pathScan.getScanQueue(), pathScan.getStartTime(), pathScan.getVolume(), pathScan.getLastScanDate(), indexingDate);
            }
            return true;
        }));
        this.threadPoolConfig.getExecutor().invokeAll(callableList).forEach(future -> {
            try {
                future.isDone();
            }
            catch (Exception e) {
                this.logger.error("There was an error while scanning all volumes", (Throwable)e);
            }
        });
        ingestFileProcessor.closeIngestProcessor();
        if (!isFirstScanOfTheDay) {
            this.tagDeletedFiles(volumeSettings, scanDate, indexingDate);
        }
    }

    private List<PathScan> getPathScans(List<VolumeScan> volumeScans) {
        ArrayList<PathScan> paths = new ArrayList<PathScan>();
        int emptyList = 0;
        int index = 0;
        while (volumeScans.size() != emptyList) {
            int pathSize = volumeScans.get(index).getPathList().size();
            if (pathSize == 1) {
                ++emptyList;
            }
            if (pathSize > 0) {
                FolderToScan path = (FolderToScan)volumeScans.get(index).getPathList().get(0);
                paths.add(new PathScan(path, volumeScans.get(index).getFileQueue(), volumeScans.get(index).getVolumeSetting(), volumeScans.get(index).getStartTime(), volumeScans.get(index).getVolume(), volumeScans.get(index).getLastScanDate()));
                volumeScans.get(index).getPathList().remove(0);
            }
            index = index == volumeScans.size() - 1 ? 0 : index + 1;
        }
        return paths;
    }

    private List<VolumeScan> getVolumeScansForVolumes(List<VolumeSetting> volumeSettings, LocalDate indexingDate, IngestFileProcessor ingestFileProcessor) {
        ArrayList volumeScanOperations = new ArrayList();
        volumeSettings.forEach(volumeSetting -> volumeScanOperations.add(() -> this.getVolumeScan(volumeSetting, indexingDate, ingestFileProcessor)));
        ArrayList<VolumeScan> volumeScans = new ArrayList<VolumeScan>();
        try {
            this.threadPoolConfig.getExecutor().invokeAll(volumeScanOperations).forEach(future -> {
                try {
                    if (future.get() != null) {
                        volumeScans.add((VolumeScan)future.get());
                    }
                }
                catch (Exception e) {
                    this.logger.error("There was an error while getting the volume scan for a volume", (Throwable)e);
                }
            });
        }
        catch (InterruptedException e) {
            this.logger.error("There was an error with the multi-thread call to get volumeScan", (Throwable)e);
        }
        return volumeScans;
    }

    private void tagDeletedFiles(List<VolumeSetting> volumeSettings, Date scanDate, LocalDate indexingDate) throws IOException {
        this.esRepository.refreshFileIndex(indexingDate);
        volumeSettings.forEach(v -> this.deletedFilesManager.tagAllDeletedFiles(Long.valueOf(v.getId()), v.getPath(), scanDate, indexingDate));
    }

    private VolumeScan getVolumeScan(VolumeSetting volumeSetting, LocalDate indexingDate, IngestFileProcessor ingestFileProcessor) {
        Volume volume = new Volume();
        VolumeScan volumeScan = new VolumeScan();
        try {
            Date scanDate = new Date();
            volume = this.volumeBuilder.createVolume(volumeSetting, scanDate, indexingDate);
            this.saveVolume(volume);
            Date lastScan = this.isFullScanNeeded(volumeSetting, scanDate) ? null : volumeSetting.getLastScan();
            volumeScan.setLastScanDate(lastScan);
            ScanQueue scanQueue = new ScanQueue(ingestFileProcessor);
            this.logger.debug("About to scan volume [{}] with path [{}] and id [{}] for changes since [{}]", new Object[]{volumeSetting.getName(), volumeSetting.getPath(), volumeSetting.getId(), lastScan});
            long start = System.currentTimeMillis();
            List pathsToScan = this.getPathsToScan(volumeSetting, scanQueue, lastScan);
            volumeScan.setStartTime(start);
            volumeScan.setVolumeSetting(volumeSetting);
            volumeScan.setFileQueue(scanQueue);
            volumeScan.setPathList(pathsToScan);
            volumeScan.setVolume(volume);
            if (pathsToScan.size() == 0) {
                this.finishVolumeScan(volumeSetting, scanQueue, start, volume, lastScan, indexingDate);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("Error while crawling files of volume %s with id %s and path %s", volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath()), (Throwable)e);
            volume.setCrawlDuration(Long.valueOf(-1L));
            this.saveVolume(volume);
            return null;
        }
        return volumeScan;
    }

    private void saveVolume(Volume volume) {
        try {
            this.esRepository.indexVolume(volume);
        }
        catch (Exception e) {
            this.logger.error("Unable to save volume", (Throwable)e);
        }
    }

    private void scanPath(VolumeSetting volumeSetting, FolderToScan folderToScan, ScanQueue scanQueue, Date lastScan) {
        try {
            Date newLastScan = folderToScan.isFullScan() ? null : lastScan;
            FullScanVisitor fullScanVisitor = new FullScanVisitor(this.fileBuilder, scanQueue, volumeSetting.getName(), Long.valueOf(volumeSetting.getId()), volumeSetting.getPath(), folderToScan.toString(), newLastScan);
            Files.walkFileTree(folderToScan.getPath(), (FileVisitor<? super Path>)fullScanVisitor);
        }
        catch (Exception e) {
            this.logger.error("Error while crawling path [{}] of volume [{}] with id [{}] and mount path [{}]", new Object[]{folderToScan, volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath(), e});
        }
    }

    private boolean isFullScanNeeded(VolumeSetting volumeSetting, Date scanDate) {
        LocalDate currentScanDate;
        Date lastScan = volumeSetting.getLastScan();
        if (lastScan == null) {
            return true;
        }
        LocalDate lastScanDate = lastScan.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (!lastScanDate.equals(currentScanDate = scanDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) {
            return true;
        }
        boolean deltaDataExist = false;
        try {
            PaginatedResult result = this.searchFiles(lastScanDate, volumeSetting);
            deltaDataExist = result.getElements().size() > 0 && ((File)result.getElements().get(0)).getIndexingDate().after(lastScan);
        }
        catch (Exception e) {
            this.logger.error("There was an error while validating the last scan. The scan will be a complete scan", (Throwable)e);
        }
        return !deltaDataExist;
    }

    private void finishVolumeScan(VolumeSetting volumeSetting, ScanQueue scanQueue, long startTime, Volume volume, Date lastScan, LocalDate indexingDate) {
        Date scanDate = new Date(startTime);
        FullScanVisitor fullScanVisitor = new FullScanVisitor(this.fileBuilder, scanQueue, volumeSetting.getName(), Long.valueOf(volumeSetting.getId()), volumeSetting.getPath(), volumeSetting.getPath(), lastScan);
        HashSet<FileVisitOption> fileVisitOptions = new HashSet<FileVisitOption>();
        try {
            this.logger.debug("About to finish the scan of volume id [{}] with the path [{}]", (Object)volumeSetting.getId(), (Object)volumeSetting.getPath());
            Files.walkFileTree(Paths.get(volumeSetting.getPath(), new String[0]), fileVisitOptions, this.multithreadFolderDepth - 1, (FileVisitor<? super Path>)fullScanVisitor);
            scanQueue.emptyDirectoryQueue();
        }
        catch (Exception e) {
            this.logger.error(String.format("Unable to finish the scan of the volume [%s] with path [%s]", volumeSetting.getId(), volumeSetting.getPath()), (Throwable)e);
        }
        long time = System.currentTimeMillis() - startTime;
        volumeSetting.setLastScan(this.getScanDate(scanDate, indexingDate));
        volume.setCrawlDuration(Long.valueOf(time));
        this.saveVolume(volume);
        this.logger.debug("Crawling files of volume {} with id {} and path {} took {} ms", new Object[]{volumeSetting.getName(), volumeSetting.getId(), volumeSetting.getPath(), time});
    }

    private PaginatedResult<File> searchFiles(LocalDate indexingDate, VolumeSetting volumeSetting) throws IOException {
        String[] sortParameters = "indexingDate,desc".split(",");
        String sortField = sortParameters[0];
        SortOrder direction = this.getESDirectionForSorting(sortParameters);
        SearchResponse response = this.esRepository.searchFiles(this.getSearchWordList(), Boolean.valueOf(false), Collections.singletonList(volumeSetting.getId()), null, null, null, null, null, null, null, null, null, null, Integer.valueOf(1), sortField, direction, null, null, null, null, Boolean.valueOf(true), null, null, null, null, indexingDate);
        return this.fileMapper.getPaginatedResult(Integer.valueOf(1), sortField, direction.toString(), response);
    }

    private List<String> getSearchWordList() {
        String searchFormatted = "".replaceAll("[^[+/\\-><!()^\"~?:]]", " ").trim();
        List<String> searchWords = Arrays.asList(searchFormatted.split(" "));
        if (searchWords.size() == 1 && searchWords.get(0).equals("")) {
            searchWords = new ArrayList<String>();
        }
        return searchWords;
    }

    private Date getScanDate(Date scanDate, LocalDate indexingDate) {
        Date newIndexingDate = scanDate;
        LocalDate scanDateFormatted = scanDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (!scanDateFormatted.equals(indexingDate)) {
            newIndexingDate = Date.from(indexingDate.atTime(23, 59, 0).atZone(ZoneId.systemDefault()).toInstant());
        }
        return newIndexingDate;
    }

    private List<FolderToScan> getPathsToScan(VolumeSetting volumeSetting, ScanQueue scanQueue, Date lastScan) throws IOException {
        Path volumeMountPoint = Paths.get(volumeSetting.getPath(), new String[0]);
        InitialScanVisitor initialScanVisitor = new InitialScanVisitor(this.fileBuilder, scanQueue, volumeSetting.getName(), Long.valueOf(volumeSetting.getId()), volumeSetting.getPath(), lastScan, this.multithreadFolderDepth);
        HashSet<FileVisitOption> fileVisitOptions = new HashSet<FileVisitOption>();
        Files.walkFileTree(volumeMountPoint, fileVisitOptions, this.multithreadFolderDepth, (FileVisitor<? super Path>)initialScanVisitor);
        return initialScanVisitor.getPaths();
    }

    private SortOrder getESDirectionForSorting(String[] sortParameter) {
        if (sortParameter.length > 1 && sortParameter[1].equalsIgnoreCase("desc")) {
            return SortOrder.DESC;
        }
        return SortOrder.ASC;
    }
}

