/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.service;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.api.jdbc.PGNotificationListener;
import io.dataintell.scanner.job.JobProcessor;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(NotificationListener.class);
    public static final int PAUSE_BEFORE_RECONNECT_TENTATIVE_IN_MS = 60000;
    public static final String LISTEN_NEW_JOB_CHANNEL = "LISTEN new_job_channel";
    private final String url;
    private final String user;
    private final String password;
    private final JobProcessor jobProcessor;
    private PGConnection pgConnection;

    public NotificationListener(@Value(value="${dataintell.scanner.postgresql.url}") String url, @Value(value="${spring.datasource.username}") String user, @Value(value="${spring.datasource.password}") String password, JobProcessor jobProcessor) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.jobProcessor = jobProcessor;
        try {
            this.makeConnection();
        }
        catch (SQLException e) {
            logger.error("Unable to connect to remote notification system", (Throwable)e);
        }
    }

    private void makeConnection() throws SQLException {
        logger.info("Connecting to remote notification system[{}]", (Object)this.url);
        this.pgConnection = DriverManager.getConnection(this.url, this.user, this.password).unwrap(PGConnection.class);
        this.pgConnection.addNotificationListener((PGNotificationListener)new /* Unavailable Anonymous Inner Class!! */);
        try (Statement statement = this.pgConnection.createStatement();){
            statement.executeUpdate(LISTEN_NEW_JOB_CHANNEL);
        }
        catch (SQLException e) {
            logger.error("Unable to LISTEN on [new_job_channel]", (Throwable)e);
        }
    }
}

