/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.repository;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.dataintell.scanner.domain.Volume;
import io.dataintell.scanner.utils.ESFileQueryUtils;
import io.dataintell.scanner.utils.ESSearchFileUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class ESRepository {
    private static final Logger log = LoggerFactory.getLogger(ESRepository.class);
    @Value(value="${dataintell.scanner.es.scrollTimeToLive}")
    private Integer scrollTimeToLive;
    private final RestHighLevelClient elasticsearchClient;

    public ESRepository(RestHighLevelClient elasticsearchClient) {
        this.elasticsearchClient = elasticsearchClient;
    }

    public SearchResponse searchFiles(List<String> searchWords, Boolean onlyDuplicate, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Integer size, String fieldSort, SortOrder sortDirection, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = ESSearchFileUtils.getInitialBoolQueryBuilderForSearch((Boolean)onlyDuplicate, volumeIds, (String)startingPath, (String)owner, (String)group, (LocalDate)lastAccessAfter, (LocalDate)lastAccessBefore, (LocalDate)lastModifiedAfter, (LocalDate)lastModifiedBefore, (LocalDate)creationAfter, (LocalDate)creationBefore, extensions, (Long)minimumSize, (Long)maximumSize, (Boolean)isDirectory, (Boolean)showOnlyDeletedFiles, volumesAndPaths, searchWords, (Long)minimumNumberOfFiles, (Long)maximumNumberOfFiles, (Long)minimumNumberOfFolders, (Long)maximumNumberOfFolders);
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = ESFileQueryUtils.getSearchRequest((QueryBuilder)boolQuery, (String)fieldSort, (SortOrder)sortDirection, (Integer)0, (Integer)size, (Boolean)true, (String)indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public void indexVolume(Volume volume) throws IOException {
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").create();
        IndexRequest indexRequest = new IndexRequest("volume").id(volume.getDocumentId()).source(gson.toJson((Object)volume), XContentType.JSON);
        this.elasticsearchClient.index(indexRequest, RequestOptions.DEFAULT);
        RefreshRequest request = new RefreshRequest(new String[]{"volume"});
        this.elasticsearchClient.indices().refresh(request, RequestOptions.DEFAULT);
    }

    public void refreshFileIndex(LocalDate indexingDate) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String indexName = "file-" + indexingDate.format(formatter);
        RefreshRequest request = new RefreshRequest(new String[]{indexName});
        this.elasticsearchClient.indices().refresh(request, RequestOptions.DEFAULT);
    }

    public GetResponse getDirectoryByDocId(String documentId, LocalDate indexingDate) throws IOException {
        GetRequest getRequest = new GetRequest(ESFileQueryUtils.getIndexName((LocalDate)indexingDate)).id(documentId);
        return this.elasticsearchClient.get(getRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getFilesOfDirectories(List<String> paths, List<Long> volumeIds, Boolean onlyDuplicates, Boolean onlyArchived, Date lastAccessDate, Integer from, Integer size, String fieldSort, SortOrder sortDirection, Boolean includeSubDirectories, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = ESFileQueryUtils.getBasicBoolQueryBuilder((Boolean)false, null);
        for (int i = 0; i < paths.size(); ++i) {
            BoolQueryBuilder volumePathBoolQuery = new BoolQueryBuilder();
            BoolQueryBuilder pathBoolQuery = new BoolQueryBuilder();
            if (includeSubDirectories.booleanValue()) {
                Object path = paths.get(i).equals("/") ? paths.get(i) : paths.get(i) + "/";
                pathBoolQuery.should((QueryBuilder)QueryBuilders.prefixQuery((String)"path.tree", (String)path));
            }
            pathBoolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"path.tree", (String)paths.get(i)));
            pathBoolQuery.minimumShouldMatch(1);
            volumePathBoolQuery.must((QueryBuilder)pathBoolQuery);
            if (Objects.nonNull(volumeIds) && Objects.nonNull(volumeIds.get(i))) {
                volumePathBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"volumeId", (Object)volumeIds.get(i)));
            }
            boolQueryBuilder.should((QueryBuilder)volumePathBoolQuery);
        }
        if (lastAccessDate != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"lastAccess").lt((Object)lastAccessDate.getTime()));
        }
        boolQueryBuilder.minimumShouldMatch("1");
        if (onlyDuplicates.booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isDupe", (boolean)true));
        }
        if (onlyArchived.booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"archivedDate"));
        }
        ArrayList<ValuesSourceAggregationBuilder> aggregationBuilders = new ArrayList<ValuesSourceAggregationBuilder>();
        aggregationBuilders.add(AggregationBuilders.sum((String)"size").field("size"));
        aggregationBuilders.add(AggregationBuilders.max((String)"lastAccess").field("lastAccess"));
        aggregationBuilders.add(AggregationBuilders.max((String)"lastModified").field("lastModified"));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = ESFileQueryUtils.getSearchRequestWithAggregation((QueryBuilder)boolQueryBuilder, (String)fieldSort, (SortOrder)sortDirection, (Integer)from, (Integer)size, (Boolean)true, aggregationBuilders, (String)indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getDirectoriesWithScroll(String path, Long volumeId, Integer size, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = ESFileQueryUtils.getBasicBoolQueryBuilder((Boolean)true, null);
        String regexPath = path.equals("/") ? "/[^/]*" : String.format("%s/[^/]*", QueryParserUtil.escape((String)path));
        boolQuery.must((QueryBuilder)QueryBuilders.regexpQuery((String)"path", (String)regexPath));
        boolQuery.mustNot((QueryBuilder)new TermQueryBuilder("path", "/"));
        boolQuery.must((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = ESFileQueryUtils.getScrollSearchRequest((QueryBuilder)boolQuery, (String)"name", (SortOrder)SortOrder.ASC, (Integer)this.scrollTimeToLive, (Integer)size, (String)indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getNextListWithScroll(String scrollId) throws IOException {
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollId).scroll(new TimeValue((long)this.scrollTimeToLive.intValue()));
        return this.elasticsearchClient.scroll(searchScrollRequest, RequestOptions.DEFAULT);
    }

    public void clearScroll(String scrollId) {
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        try {
            this.elasticsearchClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error(String.format("Unable to clear scrollId [%s]", scrollId));
        }
    }

    public SearchResponse getFilesOfDirectoryIndexedBefore(String path, Long volumeId, Date scanDate, Integer size, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = ESFileQueryUtils.getBasicBoolQueryBuilder((Boolean)false, null);
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"indexingDate").lt((Object)scanDate.getTime()));
        BoolQueryBuilder pathBoolQuery = new BoolQueryBuilder();
        Object formattedPath = path.equals("/") ? path : path + "/";
        pathBoolQuery.should((QueryBuilder)QueryBuilders.prefixQuery((String)"path", (String)formattedPath));
        pathBoolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"path", (String)path));
        pathBoolQuery.minimumShouldMatch(1);
        boolQueryBuilder.must((QueryBuilder)pathBoolQuery);
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"volumeId", (Object)volumeId));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = ESFileQueryUtils.getScrollSearchRequest((QueryBuilder)boolQueryBuilder, (String)"name", (SortOrder)SortOrder.ASC, (Integer)this.scrollTimeToLive, (Integer)size, (String)indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getDeletedFoldersByScanDateWithScroll(Integer size, Date scanDate, Long volumeId, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = ESFileQueryUtils.getBasicBoolQueryBuilder((Boolean)true, null);
        boolQuery.must((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        boolQuery.must((QueryBuilder)new RangeQueryBuilder("indexingDate").lte((Object)scanDate.getTime()));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = ESFileQueryUtils.getScrollSearchRequest((QueryBuilder)boolQuery, (String)"name", (SortOrder)SortOrder.ASC, (Integer)this.scrollTimeToLive, (Integer)size, (String)indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public void setDeletedFoldersAndFilesByPath(List<String> paths, Long volumeId, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        boolQuery.must((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        boolQuery.must((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        BoolQueryBuilder folderPaths = new BoolQueryBuilder();
        for (String path : paths) {
            folderPaths.should((QueryBuilder)new TermQueryBuilder("path", path));
        }
        folderPaths.minimumShouldMatch(1);
        boolQuery.must((QueryBuilder)folderPaths);
        UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        request.setQuery((QueryBuilder)boolQuery);
        request.setScript(new Script("ctx._source.isDeleted= 'true'"));
        request.setSlices(8);
        this.elasticsearchClient.updateByQuery(request, RequestOptions.DEFAULT);
    }

    public List<TaskInfo> getTasksByName(String name) throws IOException {
        ListTasksRequest listTasksRequest = new ListTasksRequest();
        ((ListTasksRequest)listTasksRequest.setActions(new String[]{name})).setDetailed(true);
        ListTasksResponse response = this.elasticsearchClient.tasks().list(listTasksRequest, RequestOptions.DEFAULT);
        return response.getTasks();
    }
}

