/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.mapper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.dataintell.scanner.domain.File;
import io.dataintell.scanner.domain.PaginatedResult;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.springframework.stereotype.Component;

@Component
public class FileMapper {
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();

    public File getGsonFromJson(SearchHit searchHit) {
        return (File)this.gson.fromJson(searchHit.getSourceAsString(), File.class);
    }

    public File getGsonFromJson(GetResponse getResponse) {
        return (File)this.gson.fromJson(getResponse.getSourceAsString(), File.class);
    }

    public List<File> convertToDto(SearchResponse searchResponse) {
        SearchHit[] searchHits = searchResponse.getHits().getHits();
        return Arrays.stream(searchHits).map(arg_0 -> this.getGsonFromJson(arg_0)).collect(Collectors.toList());
    }

    public PaginatedResult<File> getPaginatedResult(Integer page, String sortField, String direction, SearchResponse searchResponse) {
        PaginatedResult paginatedResult = this.getBasicPaginatedResult(page, sortField, direction, Integer.valueOf(searchResponse.getHits().getHits().length), Long.valueOf(searchResponse.getHits().getTotalHits().value), null);
        paginatedResult.setElements(this.convertToDto(searchResponse));
        return paginatedResult;
    }

    public PaginatedResult<File> getPaginatedResultWithScrollId(SearchResponse searchResponse) {
        PaginatedResult paginatedResult = this.getBasicPaginatedResult(null, null, null, Integer.valueOf(searchResponse.getHits().getHits().length), Long.valueOf(searchResponse.getHits().getTotalHits().value), searchResponse.getScrollId());
        paginatedResult.setElements(this.convertToDto(searchResponse));
        return paginatedResult;
    }

    public PaginatedResult<File> getBasicPaginatedResult(Integer page, String sortField, String direction, Integer size, Long total, String scrollId) {
        PaginatedResult paginatedResult = new PaginatedResult();
        paginatedResult.setSize(size);
        paginatedResult.setPage(page);
        paginatedResult.setTotal(total);
        paginatedResult.setSort(sortField);
        paginatedResult.setDirection(direction);
        paginatedResult.setScrollId(scrollId);
        return paginatedResult;
    }
}

