/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.job;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dataintell.scanner.job.JobStatus;
import io.dataintell.scanner.job.Payload;
import io.dataintell.scanner.service.ScanService;
import java.io.IOException;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class JobProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JobProcessor.class);
    private final long serverId;
    private final JdbcTemplate jdbcTemplate;
    private final ScanService scanService;

    public JobProcessor(@Value(value="${dataintell.scanner.server.id}") long serverId, JdbcTemplate jdbcTemplate, ScanService scanService) {
        this.serverId = serverId;
        this.jdbcTemplate = jdbcTemplate;
        this.scanService = scanService;
    }

    public void process(String jobId) {
        int id = Integer.parseInt(jobId);
        int rowsAffected = this.markJob(id, JobStatus.AVAILABLE, JobStatus.SCANNER_RUNNING);
        logger.info("Considering job id:{}", (Object)id);
        if (1 == rowsAffected) {
            try {
                logger.info("Processing job id:{}", (Object)id);
                String rawPayload = this.getRawPayload(id);
                ObjectMapper mapper = new ObjectMapper();
                Payload payload = (Payload)mapper.readValue(rawPayload, Payload.class);
                this.scanService.scanVolumes(payload);
                this.markJob(id, JobStatus.SCANNER_RUNNING, JobStatus.SCANNER_COMPLETED);
                logger.info("Finished processing job id:{}", (Object)id);
            }
            catch (JsonProcessingException e) {
                this.markJob(id, JobStatus.SCANNER_RUNNING, JobStatus.SCANNER_ERROR);
                logger.error("Failed to parse raw payload for job id:{}", (Object)id, (Object)e);
            }
            catch (IOException | InterruptedException e) {
                this.markJob(id, JobStatus.SCANNER_RUNNING, JobStatus.SCANNER_ERROR);
                logger.error("Failed to process job id:{}", (Object)id, (Object)e);
            }
        }
    }

    private String getRawPayload(int jobId) {
        return (String)this.jdbcTemplate.queryForObject("SELECT payload FROM job WHERE id=?", String.class, new Object[]{jobId});
    }

    private int markJob(int jobId, JobStatus from, JobStatus to) {
        return this.jdbcTemplate.update("UPDATE job SET status = ?, updated_at = ? WHERE id = ? AND status = ? AND server_id = ?", new Object[]{to.name(), LocalDateTime.now(), jobId, from.name(), this.serverId});
    }
}

