/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.scanner.config;

import java.time.Duration;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Elasticsearch {
    @Value(value="${dataintell.scanner.es.port}")
    private Integer elasticsearchPort;
    @Value(value="${dataintell.scanner.es.host}")
    private String elasticsearchHost;
    @Value(value="${dataintell.scanner.es.protocol}")
    private String elasticsearchProtocol;
    @Value(value="${dataintell.scanner.es.user}")
    private String elasticsearchUser;
    @Value(value="${dataintell.scanner.es.password}")
    private String elasticsearchPassword;

    @Bean
    public RestHighLevelClient elasticsearchClient() {
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.elasticsearchHost, this.elasticsearchPort.intValue(), this.elasticsearchProtocol)}).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(10000).setSocketTimeout(120000));
        if (!this.elasticsearchUser.isBlank() && !this.elasticsearchPassword.isBlank()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.elasticsearchUser, this.elasticsearchPassword));
            builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setKeepAliveStrategy((response, context) -> Duration.ofMinutes(5L).toMillis()));
        }
        return new RestHighLevelClient(builder);
    }
}

